#COMPILE EXE
#DIM ALL                                     'don't be sloppy

#RESOURCE "zentar.pbr"                       'this just contains the icon

DECLARE SUB mkDeepDir(DirName$)

%VERBOSE = 1                                 'turn this off and you'll get NO output execpt errors
%VERSION = 101                               'version code

%FASTLOAD = 1                                'load full file, instead of 512-byte blocks

'Version 1.00 - August 9
'  - Orig version
'Version 1.01 - August 10
'  - Allows resume at filename
'  - Added onlydo and startat options
'  - Hold down esc to abort

FUNCTION PBMAIN () AS LONG
   LOCAL inFile$, block$, theFilename$, ctr AS LONG, written AS LONG, createDir$, buffer$, startAt$, onlyDo$
   LOCAL theType AS LONG, theFilelength AS LONG, blocks AS LONG, outDir$, writeFile$, clicked AS LONG, escCtr AS LONG

   infile$ = PARSE$(COMMAND$, " ", 1)        'doesn't handle quoted stuff   -   c:\location\tarfile.tar
   outDir$ = PARSE$(COMMAND$, " ", 2)        '                                  c:\outputloc\
   block$ =  PARSE$(COMMAND$, " ", 3)        '  options
   IF block$ <> "" THEN
      SELECT CASE PARSE$(block$, "=", 1)
         CASE "startat"
            startAt$ = PARSE$(block$, "=", 2)
         CASE "only"
            onlyDo$ = PARSE$(block$, "=", 2)
      END SELECT
   END IF

   IF CURSORY = 1 THEN                       'cursor will be on the top line if it was a click-load, but lower if it was not
      clicked = 1
   END IF

   STDOUT "ZenTAR"                           'oh hai
   STDOUT "Version " & FORMAT$(%VERSION / 100, "0.00")
   STDOUT
   STDOUT "A utility for extracting very large tar files by Shannon from zentastic.com"
   STDOUT

   IF outDir$ = "" THEN                      'no command line variables; give help
      IF clicked = 1 THEN                    'if they clicked (and have no command line), let them enter it manually
         STDOUT "please enter the complete filename of the input .tar file"
         STDOUT "           example: f:\tar\backup.tar"
         STDOUT " -->";
         STDIN LINE inFile$
         IF inFile$ <> "" THEN               'they didn't enter a file, don't waste their time with the latter
            STDOUT "now please enter the complete name of the output directory"
            STDOUT "           example: g:\restore\"
            STDOUT " -->";
            STDIN LINE outDir$
         ELSE
            STDOUT "Ok, aborting. This program also works from the commandline."
            STDOUT "Press a key to exit."
            WAITKEY$
         END IF
         STDOUT
      ELSE
         STDOUT "usage: zentar infile outdir [option]"                        'loaded from commandline; explain usage
         STDOUT "  both are required and must be full references"
         STDOUT
         STDOUT "options:"
         STDOUT "  startat=prefix (begin process at file matching ""prefix"")"
         STDOUT "  only=prefix (only decode files matching ""prefix"")"
         STDOUT
         STDOUT "example: zentar f:\tar\backup.tar g:\restore\"
         STDOUT
         EXIT FUNCTION
      END IF
   END IF

   IF DIR$(inFile$) = "" THEN                                        'oops - file not found
      STDOUT "Input file not found ('" & inFile$ & "')"
      IF clicked = 1 THEN                                            'direct load requires a keypress to exit
         STDOUT "Press a key to exit."
         WAITKEY$
      END IF
      EXIT FUNCTION
   END IF

   IF RIGHT$(outDir$, 1) <> "\" THEN outDir$ = outDir$ & "\"         'directory ends in a slash; just keep it consistent
   IF INSTR(outDir$, ":") = 0 THEN                                   'drive letter is expected
      STDOUT "Output directory does not look right"
      IF clicked = 1 THEN                                            'direct load requires a keypress to exit
         STDOUT "Press a key to exit."
         WAITKEY$
      END IF
      EXIT FUNCTION
   END IF

   IF DIR$(LEFT$(outDir$, LEN(outDir$) - 1), 16) = "" THEN           'output directory no good
      STDOUT "Output directory not found ('" & outDir$ & "')"
      IF clicked = 1 THEN                                            'direct load requires a keypress to exit
         STDOUT "Press a key to exit."
         WAITKEY$
      END IF
      EXIT FUNCTION
   END IF

   OPEN inFile$ FOR BINARY AS #1                                     'open tar file

   DO UNTIL EOF(1)                                                   'go through file until end
      IF INSTAT <> 0 THEN                                             'anything in the keyboard buffer
         block$ = INKEY$                                             'grab keyboard buffer
         IF ASC(block$) = 27 THEN                                    'did they press esc
            INCR escCtr                                              'count it
            IF escCtr >= 3 THEN                                      'did they press three times?
               CLOSE #1                                              'close input file
               STDOUT "Aborted"                                      'tell them
               EXIT FUNCTION                                         'and quit
            END IF
         END IF
      END IF

      GET$ #1, 512, block$                                           'get the 512 byte header block

      IF LEFT$(block$, 1) = CHR$(0) THEN                             'it's probably a spacer/padding block
         ITERATE DO
      END IF

      theFilename$ = TRIM$(LEFT$(block$, 100), ANY CHR$(0,32))       'extract filename (oldschool tar format)
      theFilelength = VAL("&O" & TRIM$(MID$(block$, 125, 12), ANY CHR$(0, 32)))     'extract octal filesize
      theType = VAL(MID$(block$, 157, 1))                            'extract file type (only 0/normal and 5/dir are handled)

      IF LEN(startAt$) > 0 THEN                                      'we're in scan mode
         IF LEFT$(theFilename$, LEN(startAt$)) = startAt$ THEN       'scan successful; got match
            startAt$ = ""                                            'deactivate mode
         ELSE
            blocks = (theFilelength \ 512)                           'number of blocks required (round down)
            IF blocks * 512 < theFilelength THEN INCR blocks         'increment (most likely)
            SEEK #1, LOC(1) + (blocks * 512)                         'scan to next file
            IF %VERBOSE = 1 THEN
               STDOUT "Skip: " & theFilename$                        'skip name
            END IF
            ITERATE DO                                               'skip true load
         END IF
      END IF

      IF LEN(onlyDo$) > 0 THEN                                       'we're in match mode
         IF LEFT$(theFilename$, LEN(onlyDo$)) <> onlyDo$ THEN      'no match; skip it
            blocks = (theFilelength \ 512)                           'number of blocks required (round down)
            IF blocks * 512 < theFilelength THEN INCR blocks         'increment (most likely)
            SEEK #1, LOC(1) + (blocks * 512)                         'scan to next file
            IF %VERBOSE = 1 THEN
               STDOUT "Skip: " & theFilename$                        'skip name
            END IF
            ITERATE DO                                               'skip true load
         END IF
      END IF

      SELECT CASE theType
         CASE 5                                                      'directory; create it
            createDir$ = outDir$ & "\" & theFilename$                'prefix our output dir
            REPLACE "/" WITH "\" IN createDir$                       'unix -> win
            DO UNTIL INSTR(createDir$, "\\") = 0                     'remove double slashes
               REPLACE "\\" WITH "\" IN createDir$
            LOOP
            IF RIGHT$(createDir$, 1) = "\" THEN createDir$ = LEFT$(createDir$, LEN(createDir$) - 1)      'remove trailing slash
            MkDeepDir createDir$                                     'call directory creation sub
         CASE 0      'normal file
            blocks = (theFilelength \ 512)                           'number of blocks required (round down)
            IF blocks * 512 < theFilelength THEN INCR blocks         'increment (most likely)

            writeFile$ = outDir$ & "\" & theFilename$                'prefix with our output directory
            REPLACE "/" WITH "\" IN writeFile$                       'convert unix -> win filenames
            DO UNTIL INSTR(writeFile$, "\\") = 0                     'remove double slashes (unlikely)
               REPLACE "\\" WITH "\" IN writeFile$
            LOOP
            createDir$ = LEFT$(writeFile$, INSTR(-1, writeFile$, "\") - 1)     'extract directory only
            'does dir exist?
            IF DIR$(createDir$, 16) = "" THEN                        'does directory exist?
               MkDeepDir createDir$                                  'create directory if it doesn't
            END IF
            IF %VERBOSE = 1 THEN
               STDOUT writeFile$ & " (" & FORMAT$(theFilelength, "0,") & " bytes)"      'output filename
            END IF
            IF %FASTLOAD = 0 THEN
               GET$ #1, blocks * 512, block$                            'suck in entire file
               OPEN writeFile$ FOR OUTPUT AS #2                         'open output file
               PRINT #2, LEFT$(block$, theFilelength);                  'write file
               CLOSE #2                                                 'and close the output file
            ELSE
               written = 0
               OPEN writeFile$ FOR OUTPUT AS #2                         'open output file
               FOR ctr = 1 TO blocks                                    'grab blocks one by one (note: this could be sped up easily)
                  GET$ #1, 512, block$                                  'grab a 512 byte block
                  IF theFilelength - written => 512 THEN                'are we writing a full block?
                     PRINT #2, block$;                                  'output full block
                     written = written + 512                            'increase counter by a full block
                  ELSE
                     PRINT #2, LEFT$(block$, theFilelength - written)   'output the partial block
                  END IF
               NEXT
               CLOSE #2                                                 'close the output file
            END IF
         CASE ELSE                                                   'unhandled file type
            IF %VERBOSE = 1 THEN                                     'output error data
               STDOUT theFilename$ & " (" & FORMAT$(theFilelength, "0,") & " bytes)"
               STDOUT "ERROR: Type problem!"
               STDOUT "Unhandled: " & FORMAT$(theType)
               STDOUT "Contact me at www.zentastic.com and I'll add support."
               STDOUT " ==press any key==";
               WAITKEY$
               LOCATE ,1
               STDOUT "                  ";
               LOCATE ,1
            END IF
      END SELECT

   LOOP

   CLOSE #1                                                          'close input file; done!

   IF clicked = 1 THEN                                               'loaded by a window click; don't close instatly
      INPUT FLUSH                                                    'clear keyboard buffer
      STDOUT "We're all done!"                                       'tell them we finished
      STDOUT "Press a key to exit"
      WAITKEY$                                                       'and wait for a keypress
   END IF


END FUNCTION

SUB mkDeepDir(DirName$)                   'create a directory tree (assumes driveletter + no trailing slash)
   LOCAL numTerms AS LONG, curMake$, ctr AS LONG
   numTerms = PARSECOUNT(DirName$, "\")                              'depth of this directory tree
   curMake$ = PARSE$(DirName$, "\", 1) & "\"                         'asssumes driveletter is first term; skip it and seed it
   IF %VERBOSE = 1 THEN
      STDOUT "Create directory: " & DirName$                         'tell the user what we're doing
   END IF
   FOR ctr = 2 TO numTerms                                           'count through tree
      curMake$ = curMake$ & PARSE$(DirName$, "\", ctr) & "\"         'add next step in tree
      IF DIR$(LEFT$(curMake$, LEN(curMake$) - 1), 16) = "" THEN
         MKDIR LEFT$(curMake$, LEN(curMake$) - 1)                    'and create this
      END IF
   NEXT
END SUB
