#COMPILE EXE
#DIM ALL

DECLARE SUB SequenceIt(Confirmed$, Remaining$)

GLOBAL theDepth AS LONG
GLOBAL OutputDone$

FUNCTION PBMAIN () AS LONG
   LOCAL theInput$, temp$
   LOCAL viaCmd AS LONG

   IF COMMAND$ <> "" THEN
      viaCMD = 1
      theInput$ = PARSE$(COMMAND$, " ", 1)
      theDepth = VAL(PARSE$(COMMAND$, " ", 2))
      IF PARSECOUNT(theInput$) <= 1 THEN
         STDOUT "SEQUENCES"
         STDOUT "Usage:"
         STDOUT "  sequences one,two,three,etc [depth]"
         STDOUT ""
         EXIT FUNCTION
      END IF
   ELSE
      STDOUT "SEQUENCES"
      STDOUT "Note: you can also enter your variables on the command line, comma separated"
      STDOUT "Enter your variables now:"
      STDOUT "-->";
      STDIN LINE theInput$
      IF PARSECOUNT(theInput$) <= 1 THEN
         STDOUT "Error: You need to enter at least two variables, separated by commas!"
         STDOUT ""
         EXIT FUNCTION
      END IF
      STDOUT "Depth limitation? (Blank for no)"
      STDOUT "-->";
      STDIN LINE temp$
      theDepth = VAL(temp$)
   END IF

   OutputDone$ = $CRLF

   SequenceIt "", theInput$

   IF viaCMD = 0 THEN
      STDOUT ""
      STDOUT "<press any key to exit>";
      WAITKEY$
      STDOUT ""
   END IF

END FUNCTION


SUB SequenceIt(Confirmed$, Remaining$)
   LOCAL numRemaining AS LONG
   LOCAL remTerm$()
   LOCAL ctr AS LONG, ctr2 AS LONG
   LOCAL newRem$, newCon$, potentialOutput$

   numRemaining = PARSECOUNT(Remaining$)
   IF numRemaining <= 1 THEN
      potentialOutput$ = Confirmed$ & "," & Remaining$
      IF theDepth > 0 AND PARSECOUNT(potentialOutput$) > theDepth THEN
         FOR ctr = 1 TO theDepth
            newRem$ = newRem$ & PARSE$(potentialOutput$, ctr) & ","
         NEXT
         potentialOutput$ = LEFT$(newRem$, LEN(newRem$) - 1)
      END IF
      REPLACE "," WITH ", " IN potentialOutput$
      IF INSTR(OutputDone$, $CRLF & potentialOutput$ & $CRLF) = 0 THEN
         STDOUT potentialOutput$
         OutputDone$ = OutputDone$ & potentialOutput$ & $CRLF
      END IF
   ELSE
      REDIM remTerm$(numRemaining)
      FOR ctr = 1 TO numRemaining
         remTerm$(ctr) = PARSE$(Remaining$, ctr)
      NEXT

      FOR ctr = 1 TO numRemaining
         newRem$ = ""
         FOR ctr2 = 1 TO numRemaining
            IF ctr2 <> ctr THEN
               newRem$ = newRem$ & TRIM$(PARSE$(Remaining$, ctr2)) & ","
            END IF
         NEXT
         newRem$ = LEFT$(newRem$, LEN(newRem$) - 1)
         IF Confirmed$ = "" THEN
            newCon$ = TRIM$(PARSE$(Remaining$, ctr))
         ELSE
            newCon$ = Confirmed$ & "," & TRIM$(PARSE$(Remaining$, ctr))
         END IF
         SequenceIt newCon$, newRem$
      NEXT
   END IF
END SUB
